package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExcludePausedCompetingAds;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class CampaignWithExcludePausedCompetingAdsValidator
        implements Validator<CampaignWithExcludePausedCompetingAds, Defect> {

    @Override
    public ValidationResult<CampaignWithExcludePausedCompetingAds, Defect> apply(CampaignWithExcludePausedCompetingAds campaign) {
        ModelItemValidationBuilder<CampaignWithExcludePausedCompetingAds> vb =
                ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithExcludePausedCompetingAds.EXCLUDE_PAUSED_COMPETING_ADS)
                .check(notNull());
        return vb.getResult();
    }

}
