package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.List;
import java.util.function.Predicate;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.core.validation.defects.RightsDefects;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

public class CampaignWithExperimentsAddPreValidator implements Validator<CampaignWithExperiments, Defect> {
    private final boolean abSegmentsEnabledForClientId;
    private final boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId;

    public CampaignWithExperimentsAddPreValidator(boolean abSegmentsEnabledForClientId,
                                                  boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId) {
        this.abSegmentsEnabledForClientId = abSegmentsEnabledForClientId;
        this.experimentRetargetingConditionsAutoCreatingEnabledForClientId =
                experimentRetargetingConditionsAutoCreatingEnabledForClientId;
    }

    @Override
    public ValidationResult<CampaignWithExperiments, Defect> apply(CampaignWithExperiments campaign) {
        ModelItemValidationBuilder<CampaignWithExperiments> vb = ModelItemValidationBuilder.of(campaign);

        checkItem(vb, CampaignWithExperiments.AB_SEGMENT_RETARGETING_CONDITION_ID,
                conditionId -> abSegmentsEnabledForClientId &&
                        !experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkItem(vb, CampaignWithExperiments.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                conditionId -> abSegmentsEnabledForClientId &&
                        !experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkList(vb, CampaignWithExperiments.SECTION_IDS,
                conditionId -> abSegmentsEnabledForClientId &&
                        experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkList(vb, CampaignWithExperiments.AB_SEGMENT_GOAL_IDS,
                conditionId -> abSegmentsEnabledForClientId &&
                        experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        return vb.getResult();
    }

    private <M extends ModelWithId, V> void checkItem(
            ModelItemValidationBuilder<M> vb,
            ModelProperty<? super M, V> property,
            Predicate<V> predicate) {
        Constraint<V, Defect> constraint = Constraint.fromPredicate(predicate, RightsDefects.noRights());
        vb.item(property)
                .check(constraint, When.notNull());
    }

    private <M extends ModelWithId, V> void checkList(
            ModelItemValidationBuilder<M> vb,
            ModelProperty<? super M, List<V>> property,
            Predicate<List<V>> predicate) {
        Constraint<List<V>, Defect> constraint = Constraint.fromPredicate(predicate, RightsDefects.noRights());
        vb.list(property)
                .check(constraint, When.notNull());
    }
}
