package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.List;
import java.util.function.Predicate;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.core.validation.defects.RightsDefects;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

public class CampaignWithExperimentsUpdatePreValidator implements Validator<ModelChanges<CampaignWithExperiments>,
        Defect> {
    private final boolean abSegmentsEnabledForClientId;
    private final boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId;

    public CampaignWithExperimentsUpdatePreValidator(boolean abSegmentsEnabledForClientId,
                                                     boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId) {
        this.abSegmentsEnabledForClientId = abSegmentsEnabledForClientId;
        this.experimentRetargetingConditionsAutoCreatingEnabledForClientId =
                experimentRetargetingConditionsAutoCreatingEnabledForClientId;
    }

    @Override
    public ValidationResult<ModelChanges<CampaignWithExperiments>, Defect> apply(ModelChanges<CampaignWithExperiments> campaign) {
        ItemValidationBuilder<ModelChanges<CampaignWithExperiments>, Defect> vb =
                ModelItemValidationBuilder.of(campaign);

        checkItemIfChanged(vb, campaign, CampaignWithExperiments.AB_SEGMENT_RETARGETING_CONDITION_ID,
                conditionId -> abSegmentsEnabledForClientId &&
                        !experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkItemIfChanged(vb, campaign, CampaignWithExperiments.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                conditionId -> abSegmentsEnabledForClientId &&
                        !experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkListIfChanged(vb, campaign, CampaignWithExperiments.SECTION_IDS,
                conditionId -> abSegmentsEnabledForClientId &&
                        experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        checkListIfChanged(vb, campaign, CampaignWithExperiments.AB_SEGMENT_GOAL_IDS,
                conditionId -> abSegmentsEnabledForClientId &&
                        experimentRetargetingConditionsAutoCreatingEnabledForClientId);

        return vb.getResult();
    }

    private <M extends ModelWithId, V> void checkItemIfChanged(ItemValidationBuilder<ModelChanges<M>, Defect> vb,
                                                               ModelChanges<M> campaign,
                                                               ModelProperty<? super M, V> property,
                                                               Predicate<V> predicate) {
        if (campaign.isPropChanged(property)) {
            Constraint<V, Defect> constraint = Constraint.fromPredicate(predicate, RightsDefects.noRights());
            vb.item(campaign.getChangedProp(property), property.name())
                    .check(constraint, When.notNull());
        }
    }

    private <M extends ModelWithId, V> void checkListIfChanged(ItemValidationBuilder<ModelChanges<M>, Defect> vb,
                                                               ModelChanges<M> campaign,
                                                               ModelProperty<? super M, List<V>> property,
                                                               Predicate<List<V>> predicate) {
        if (campaign.isPropChanged(property)) {
            Constraint<List<V>, Defect> constraint = Constraint.fromPredicate(predicate, RightsDefects.noRights());
            vb.list(campaign.getChangedProp(property), property.name())
                    .check(constraint, When.notNull());
        }
    }
}
