package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@ParametersAreNonnullByDefault
public class CampaignWithExperimentsUpdateValidator implements Validator<CampaignWithExperiments, Defect> {
    private final Set<Long> clientConditionIds;
    private final List<RetargetingCondition> clientAbSegments;
    private final AppliedChanges<CampaignWithExperiments> appliedChanges;

    private CampaignWithExperimentsUpdateValidator(
            Set<Long> clientConditionIds,
            List<RetargetingCondition> clientAbSegments,
            @Nullable AppliedChanges<CampaignWithExperiments> appliedChanges
    ) {
        this.clientConditionIds = clientConditionIds;
        this.clientAbSegments = clientAbSegments;
        this.appliedChanges = appliedChanges;
    }

    public static CampaignWithExperimentsUpdateValidator build(
            Set<Long> clientConditionIds,
            List<RetargetingCondition> clientAbSegments,
            @Nullable AppliedChanges<CampaignWithExperiments> appliedChanges
    ) {
        return new CampaignWithExperimentsUpdateValidator(clientConditionIds, clientAbSegments, appliedChanges);
    }

    @Override
    public ValidationResult<CampaignWithExperiments, Defect> apply(CampaignWithExperiments campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);

        Set<Long> clientSectionIds = StreamEx.of(clientAbSegments)
                .map(RetargetingCondition::getSectionId)
                .nonNull()
                .toSet();

        Set<Long> clientAbSegmentIds = listToSet(clientAbSegments,
                ru.yandex.direct.metrika.client.model.response.RetargetingCondition::getId);

        vb.item(CampaignWithExperiments.AB_SEGMENT_RETARGETING_CONDITION_ID)
                .check(inSet(clientConditionIds), When.isValid());
        vb.item(CampaignWithExperiments.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID)
                .check(inSet(clientConditionIds), When.isValid());

        vb.list(CampaignWithExperiments.SECTION_IDS)
                .checkEach(inSet(clientSectionIds), When.isValidAnd(When.isTrue(appliedChanges == null
                        || appliedChanges.changed(CampaignWithExperiments.SECTION_IDS))));
        vb.list(CampaignWithExperiments.AB_SEGMENT_GOAL_IDS)
                .checkEach(inSet(clientAbSegmentIds), When.isValidAnd(When.isTrue(appliedChanges == null
                        || appliedChanges.changed(CampaignWithExperiments.AB_SEGMENT_GOAL_IDS))));

        return vb.getResult();
    }
}
