package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenWwManagedOrderFlag;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.inconsistentCampaignType;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

public class CampaignWithForbiddenWwManagedOrderFlagValidator implements Validator<CampaignWithForbiddenWwManagedOrderFlag, Defect> {
    @Override
    public ValidationResult<CampaignWithForbiddenWwManagedOrderFlag, Defect> apply(
            CampaignWithForbiddenWwManagedOrderFlag campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithForbiddenWwManagedOrderFlag.IS_WW_MANAGED_ORDER)
                .check(notTrue(), inconsistentCampaignType());
        return vb.getResult();
    }
}
