package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithFrontpageTypes;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.minSetSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithFrontpageTypesValidator implements Validator<CampaignWithFrontpageTypes, Defect> {

    @Override
    public ValidationResult<CampaignWithFrontpageTypes, Defect> apply(CampaignWithFrontpageTypes campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithFrontpageTypes.ALLOWED_FRONTPAGE_TYPE)
                .check(notNull())
                .check(minSetSize(1))
                .check(eachInSetNotNull());

        return vb.getResult();
    }
}
