package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_IMPRESSION_RATE_COUNT_WITHOUT_FEATURE;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_IMPRESSION_RATE_COUNT_WITH_FEATURE;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;
import static ru.yandex.direct.validation.defect.CommonDefects.inconsistentState;

@ParametersAreNonnullByDefault
public class CampaignWithImpressionRateValidator implements Validator<CampaignWithImpressionRate, Defect> {

    private boolean isCpmShowsFrequency50Per30On;

    @Override
    public ValidationResult<CampaignWithImpressionRate, Defect> apply(CampaignWithImpressionRate campaign) {
        ModelItemValidationBuilder<CampaignWithImpressionRate> vb = ModelItemValidationBuilder.of(campaign);
        vb.check(ifHasIntervalDaysCountShouldBeFilled());

        vb.item(CampaignWithImpressionRate.IMPRESSION_RATE_COUNT)
                .check(inRange(1, isCpmShowsFrequency50Per30On ?
                                  MAX_IMPRESSION_RATE_COUNT_WITH_FEATURE :
                                  MAX_IMPRESSION_RATE_COUNT_WITHOUT_FEATURE),
                        When.notNull());
        return vb.getResult();
    }

    /**
     * Если есть количество дней, то должно быть количество показов
     */
    private Constraint<CampaignWithImpressionRate, Defect> ifHasIntervalDaysCountShouldBeFilled() {
        return Constraint.fromPredicate(
                campaign -> campaign.getImpressionRateCount() != null
                        || campaign.getImpressionRateIntervalDays() == null,
                inconsistentState());
    }

    public CampaignWithImpressionRateValidator(boolean isCpmShowsFrequency50Per30On) {
        this.isCpmShowsFrequency50Per30On = isCpmShowsFrequency50Per30On;
    }

}
