package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurer;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurerParamsIas;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurerSystem;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeasurers;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class CampaignWithMeasurersValidator implements Validator<CampaignWithMeasurers, Defect> {
    private final static Map<CampaignMeasurerSystem, FeatureName> measureFeatures = Map.of(
            CampaignMeasurerSystem.MOAT, FeatureName.MOAT_MEASURER_CAMP,
            CampaignMeasurerSystem.IAS, FeatureName.IAS_MEASURER
    );

    private final Set<String> featuresEnabledToClient;

    public CampaignWithMeasurersValidator(Set<String> featuresEnabledToClient) {
        this.featuresEnabledToClient = featuresEnabledToClient;
    }

    private static Constraint<CampaignMeasurer, Defect> allowedIasParams() {
        return ri -> {
            var campaignMeasurerParamsIas = fromJson(ri.getParams(), CampaignMeasurerParamsIas.class);
            if (campaignMeasurerParamsIas.getAdvid() == null && campaignMeasurerParamsIas.getPubid() == null) {
                return invalidValue();
            }
            return null;
        };
    }

    @Override
    public ValidationResult<CampaignWithMeasurers, Defect> apply(CampaignWithMeasurers campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.list(CampaignWithMeasurers.MEASURERS)
                .checkEach(Constraint.fromPredicate(
                        ri -> featuresEnabledToClient.contains(measureFeatures.get(ri.getMeasurerSystem()).getName()),
                        invalidValue())
                )
                .checkEach(
                        allowedIasParams(),
                        When.valueIs(ri -> ri.getMeasurerSystem() == CampaignMeasurerSystem.IAS));

        return vb.getResult();
    }
}
