package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.List;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseBeforeNormalizationValidator.minusKeywordsAreValidBeforeNormalization;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH_BEFORE_NORMALIZATION;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE_AND_KEYWORD;

/**
 * Валидаторы для валидации минус-фраз до их нормализации и подготовки к сохранению
 */
public class CampaignWithMinusKeywordsPreValidators {
    private CampaignWithMinusKeywordsPreValidators() {}

    private static final Validator<List<String>, Defect> MINUS_KEYWORDS_PRE_VALIDATOR =
            minusKeywords -> {
                ItemValidationBuilder<List<String>, Defect> vb = ItemValidationBuilder.of(minusKeywords);
                vb.checkBy(minusKeywordsAreValidBeforeNormalization(
                        CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH_BEFORE_NORMALIZATION, ONE_ERROR_PER_TYPE_AND_KEYWORD));
                return vb.getResult();
            };

    public static final Validator<CampaignWithMinusKeywords, Defect> CAMPAIGN_VALIDATOR =
            campaign -> {
                ModelItemValidationBuilder<CampaignWithMinusKeywords> vb = ModelItemValidationBuilder.of(campaign);
                vb.item(CampaignWithMinusKeywords.MINUS_KEYWORDS)
                        .checkBy(MINUS_KEYWORDS_PRE_VALIDATOR, When.notNull());
                return vb.getResult();
            };

    public static final Validator<ModelChanges<CampaignWithMinusKeywords>, Defect> MODEL_CHANGES_VALIDATOR =
            mc -> {
                ItemValidationBuilder<ModelChanges<CampaignWithMinusKeywords>, Defect> vb = ItemValidationBuilder.of(mc);
                if (mc.isPropChanged(CampaignWithMinusKeywords.MINUS_KEYWORDS)) {
                    vb.item(mc.getChangedProp(CampaignWithMinusKeywords.MINUS_KEYWORDS),
                            CampaignWithMinusKeywords.MINUS_KEYWORDS.name())
                            .checkBy(MINUS_KEYWORDS_PRE_VALIDATOR, When.notNull());
                }
                return vb.getResult();
            };
}
