package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxLengthKeywordsWithoutSpecSymbolsAndSpaces;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints.maxWordsInKeywords;

public class CampaignWithMinusKeywordsValidator implements Validator<CampaignWithMinusKeywords, Defect> {
    @Override
    public ValidationResult<CampaignWithMinusKeywords, Defect> apply(CampaignWithMinusKeywords campaign) {
        ModelItemValidationBuilder<CampaignWithMinusKeywords> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithMinusKeywords.MINUS_KEYWORDS)
                .check(maxLengthKeywordsWithoutSpecSymbolsAndSpaces(CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH))
                .check(maxWordsInKeywords());
        return vb.getResult();
    }
}
