package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersionForbidden;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionForbiddenValidator<T extends CommonCampaign> implements Validator<T, Defect> {

    @Override
    public ValidationResult<T, Defect> apply(T campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithNewIosVersionForbidden.IS_NEW_IOS_VERSION_ENABLED).check(isNull());
        return vb.getResult();
    }
}
