package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddMetrikaTagToUrl;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddMetrikaTagToUrlValidator implements Validator<CampaignWithOptionalAddMetrikaTagToUrl, Defect> {

    @Override
    public ValidationResult<CampaignWithOptionalAddMetrikaTagToUrl, Defect> apply(CampaignWithOptionalAddMetrikaTagToUrl campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalAddMetrikaTagToUrl.HAS_ADD_METRIKA_TAG_TO_URL)
                .check(notNull());
        return vb.getResult();
    }
}
