package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddOpenstatTagToUrl;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddOpenstatTagToUrlValidator implements Validator<CampaignWithOptionalAddOpenstatTagToUrl,
        Defect> {
    @Override
    public ValidationResult<CampaignWithOptionalAddOpenstatTagToUrl, Defect> apply(CampaignWithOptionalAddOpenstatTagToUrl campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalAddOpenstatTagToUrl.HAS_ADD_OPENSTAT_TAG_TO_URL)
                .check(notNull());
        return vb.getResult();
    }
}
