package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAloneTrafaret;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalAloneTrafaretValidator
        implements Validator<CampaignWithOptionalAloneTrafaret, Defect> {

    private boolean isAloneTrafaretOptionEnabled;

    public CampaignWithOptionalAloneTrafaretValidator(boolean isAloneTrafaretOptionEnabled) {
        this.isAloneTrafaretOptionEnabled = isAloneTrafaretOptionEnabled;
    }

    @Override
    public ValidationResult<CampaignWithOptionalAloneTrafaret, Defect> apply(
            CampaignWithOptionalAloneTrafaret campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalAloneTrafaret.IS_ALONE_TRAFARET_ALLOWED)
                .check(notNull(), When.isTrue(isAloneTrafaretOptionEnabled))
                .check(notTrue(), When.isFalse(isAloneTrafaretOptionEnabled));
        return vb.getResult();
    }

}
