package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalHasTurboSmartsForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalHasTurboSmartsForbiddenValidator
        implements Validator<CampaignWithOptionalHasTurboSmartsForbidden, Defect> {
    @Override
    public ValidationResult<CampaignWithOptionalHasTurboSmartsForbidden, Defect> apply(
            CampaignWithOptionalHasTurboSmartsForbidden campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalHasTurboSmartsForbidden.HAS_TURBO_SMARTS)
                .check(isNull());
        return vb.getResult();
    }
}
