package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalHasTurboSmarts;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalHasTurboSmartsValidator implements Validator<CampaignWithOptionalHasTurboSmarts,
        Defect> {

    private boolean hasTurboSmarts;

    public CampaignWithOptionalHasTurboSmartsValidator(boolean hasTurboSmarts) {
        this.hasTurboSmarts = hasTurboSmarts;
    }

    @Override
    public ValidationResult<CampaignWithOptionalHasTurboSmarts, Defect> apply(
            CampaignWithOptionalHasTurboSmarts campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalHasTurboSmarts.HAS_TURBO_SMARTS)
                .check(notNull(), When.isTrue(hasTurboSmarts));
        return vb.getResult();
    }

}
