package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrika;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaValidator implements Validator<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika,
        Defect> {

    public static final Set<StrategyName> STRATEGY_TYPES_AVAILABLE_FOR_MEANINGFUL_GOALS_VALUES_FROM_METRIKA =
            ImmutableSet.of(StrategyName.AUTOBUDGET_ROI);

    @Override
    public ValidationResult<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika, Defect> apply(CampaignWithOptionalMeaningfulGoalsValuesFromMetrika campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);

        boolean isMeaningfulGoalsValuesFromMetrikaEnabled =
                nvl(campaign.getIsMeaningfulGoalsValuesFromMetrikaEnabled(), false);

        DbStrategy strategy = campaign.getStrategy();

        vb.item(CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED)
                .check(isStrategyTypeSupported(strategy), When.isTrue(isMeaningfulGoalsValuesFromMetrikaEnabled))
                .check(strategyGoalIdIsAllMeaningfulGoalsOptimization(strategy),
                        When.isTrue(isMeaningfulGoalsValuesFromMetrikaEnabled));

        return vb.getResult();
    }

    // получение ценности из Метрики можно использовать только определенных типов стратегий
    private static Constraint<Boolean, Defect> isStrategyTypeSupported(DbStrategy strategy) {
        return fromPredicate(
                value -> STRATEGY_TYPES_AVAILABLE_FOR_MEANINGFUL_GOALS_VALUES_FROM_METRIKA.contains(strategy.getStrategyName()),
                StrategyDefects.meaningfulGoalsValuesFromMetrikaInconsistentStrategy()
        );
    }

    //для получения ценности из метрики нужно выбрать оптимизацияю по всем КЦ
    private static Constraint<Boolean, Defect> strategyGoalIdIsAllMeaningfulGoalsOptimization(DbStrategy strategy) {
        return fromPredicate(
                value -> MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID.equals(strategy.getStrategyData().getGoalId()),
                StrategyDefects.meaningfulGoalsValuesFromMetrikaAllowOnlyAllGoals()
        );
    }
}
