package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalRequireFiltrationByDontShowDomains;
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign;
import ru.yandex.direct.core.entity.campaign.model.McBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.model.CampaignTypeKinds.CPM;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

public class CampaignWithOptionalRequireFiltrationByDontShowDomainsValidator {

    private final boolean featureForAllTypesEnabled;
    private final boolean featureForCpmTypesEnabled;

    static final Set<CampaignType> UNVERIFIABLE_CAMPAIGN_TYPES =
            Set.of(CampaignType.CONTENT_PROMOTION, CampaignType.MOBILE_CONTENT, CampaignType.MCBANNER);

    public CampaignWithOptionalRequireFiltrationByDontShowDomainsValidator(boolean featureForAllTypesEnabled,
                                                                           boolean featureForCpmTypesEnabled) {
        this.featureForAllTypesEnabled = featureForAllTypesEnabled;
        this.featureForCpmTypesEnabled = featureForCpmTypesEnabled;
    }

    public ValidationResult<CampaignWithOptionalRequireFiltrationByDontShowDomains, Defect> apply(
            CampaignWithOptionalRequireFiltrationByDontShowDomains campaign, boolean forUpdate) {

        var vb = ModelItemValidationBuilder.of(campaign);
        // TODO (dimitrovsd): оторвать этот грязный костыль после закрытия старого интерфейса
        if (UNVERIFIABLE_CAMPAIGN_TYPES.contains(campaign.getType())) {
            return vb.getResult();
        }

        var ivb =
                vb.item(CampaignWithOptionalRequireFiltrationByDontShowDomains.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        boolean canRequireFiltrationByDontShowDomains = canRequireFiltrationByDontShowDomains(
                campaign.getType(), featureForAllTypesEnabled, featureForCpmTypesEnabled);

        // ivb.check(notNull(), When.isTrue(canRequireFiltrationByDontShowDomains));

        // Опцию можно выставлять через внутренний отчет, поэтому не нужно валидировать ее отсутствие при update
        if (!forUpdate) {
            ivb.check(notTrue(), When.isFalse(canRequireFiltrationByDontShowDomains));
        }

        return vb.getResult();
    }

    public ValidationResult<ModelChanges<CampaignWithOptionalRequireFiltrationByDontShowDomains>, Defect>
    applyForModelChanges(
            CampaignValidationContainer container,
            ModelChanges<CampaignWithOptionalRequireFiltrationByDontShowDomains> modelChanges) {
        var vb = ModelItemValidationBuilder.<ModelChanges<CampaignWithOptionalRequireFiltrationByDontShowDomains>,
                Defect>of(modelChanges);

        // TODO (dimitrovsd): оторвать этот грязный костыль после закрытия старого интерфейса
        var runtimeClass = container.getRuntimeClass(modelChanges.getId());
        if (ContentPromotionCampaign.class.isAssignableFrom(runtimeClass)
                || MobileContentCampaign.class.isAssignableFrom(runtimeClass)
                || McBannerCampaign.class.isAssignableFrom(runtimeClass)) {
            return vb.getResult();
        }

        boolean canRequireFiltrationByDontShowDomains = canRequireFiltrationByDontShowDomains(
                container.getCampaignType(modelChanges.getId()), featureForAllTypesEnabled, featureForCpmTypesEnabled);

        vb.check(fromPredicate(mc -> !mc.isPropChanged(
                CampaignWithOptionalRequireFiltrationByDontShowDomains.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS),
                invalidValue()),
                When.isFalse(canRequireFiltrationByDontShowDomains));

        return vb.getResult();
    }

    public static boolean canRequireFiltrationByDontShowDomains(
            CampaignType campaignType, boolean featureForAllTypesEnabled, boolean featureForCpmTypesEnabled) {

        if (featureForAllTypesEnabled) {
            return true;
        }
        return featureForCpmTypesEnabled && CPM.contains(campaignType);
    }
}
