package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalS2sTrackingForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

public class CampaignWithOptionalS2sTrackingForbiddenValidator implements Validator<CampaignWithOptionalS2sTrackingForbidden, Defect> {
    @Override
    public ValidationResult<CampaignWithOptionalS2sTrackingForbidden, Defect> apply(CampaignWithOptionalS2sTrackingForbidden campaignWithOptionalS2sTrackingForbidden) {
        var vb = ModelItemValidationBuilder.of(campaignWithOptionalS2sTrackingForbidden);
        vb.item(CampaignWithOptionalS2sTrackingForbidden.IS_S2S_TRACKING_ENABLED)
                .check(isNull());
        return vb.getResult();
    }
}
