package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalS2sTracking;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalS2sTrackingValidator implements Validator<CampaignWithOptionalS2sTracking, Defect> {

    private final boolean isS2sTrackingFeatureEnabled;

    public CampaignWithOptionalS2sTrackingValidator(boolean isS2sTrackingFeatureEnabled) {
        this.isS2sTrackingFeatureEnabled = isS2sTrackingFeatureEnabled;
    }

    @Override
    public ValidationResult<CampaignWithOptionalS2sTracking, Defect> apply(CampaignWithOptionalS2sTracking campaignWithOptionalS2sTracking) {
        var vb = ModelItemValidationBuilder.of(campaignWithOptionalS2sTracking);
        vb.item(CampaignWithOptionalS2sTracking.IS_S2S_TRACKING_ENABLED)
//                .check(notNull(), When.isTrue(isS2sTrackingFeatureEnabled))
                .check(notTrue(), When.isFalse(isS2sTrackingFeatureEnabled));
        return vb.getResult();
    }
}
