package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalTitleSubstitution;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithOptionalTitleSubstitutionValidator implements Validator<CampaignWithOptionalTitleSubstitution,
        Defect> {
    @Override
    public ValidationResult<CampaignWithOptionalTitleSubstitution, Defect> apply(CampaignWithOptionalTitleSubstitution campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithOptionalTitleSubstitution.HAS_TITLE_SUBSTITUTION)
                .check(notNull());
        return vb.getResult();
    }
}
