package ru.yandex.direct.core.entity.campaign.service.validation.type.bean

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoals
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.model.DbStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpaPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpcPerFilter
import ru.yandex.direct.core.entity.strategy.model.AutobudgetAvgCpi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetCrr
import ru.yandex.direct.core.entity.strategy.model.AutobudgetMedia
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi
import ru.yandex.direct.core.entity.strategy.model.AutobudgetWeekBundle
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpv
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithCustomPeriodBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithDayBudget
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMeaningfulGoals
import ru.yandex.direct.core.entity.strategy.model.StrategyWithMetrikaCounters
import ru.yandex.direct.core.entity.strategy.model.StrategyWithPayForConversion
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.utils.StrategyComparingUtils.arePropertyValuesEquals
import ru.yandex.direct.model.Model
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.model.ModelProperty

object CampaignWithPackageStrategyUpdatePreValidatorHelper {
    private val CampaignModelPropertiesAffectsStrategy =
        setOf<ModelProperty<out Model, *>>(
            CampaignWithPackageStrategy.STRATEGY,
            CampaignWithMetrikaCounters.METRIKA_COUNTERS,
            CampaignWithMeaningfulGoals.MEANINGFUL_GOALS,
            CampaignWithDayBudget.DAY_BUDGET,
            CampaignWithDayBudget.DAY_BUDGET_SHOW_MODE,
            CampaignWithAttributionModel.ATTRIBUTION_MODEL,
            CommonCampaign.ENABLE_CPC_HOLD,
        )

    private val CampaignModelPropertiesAffectsStrategyMapping =
        mapOf<ModelProperty<out Model, *>, ModelProperty<out Model, *>>(
            CampaignWithMetrikaCounters.METRIKA_COUNTERS to StrategyWithMetrikaCounters.METRIKA_COUNTERS,
            CampaignWithMeaningfulGoals.MEANINGFUL_GOALS to StrategyWithMeaningfulGoals.MEANINGFUL_GOALS,
            CampaignWithDayBudget.DAY_BUDGET to StrategyWithDayBudget.DAY_BUDGET,
            CampaignWithDayBudget.DAY_BUDGET_SHOW_MODE to StrategyWithDayBudget.DAY_BUDGET_SHOW_MODE,
            CampaignWithAttributionModel.ATTRIBUTION_MODEL to CommonStrategy.ATTRIBUTION_MODEL,
            CommonCampaign.ENABLE_CPC_HOLD to DefaultManualStrategy.ENABLE_CPC_HOLD,
        )

    private val CampaignStrategyPropertiesAffectsStrategyMapping =
        mapOf<ModelProperty<out Model, *>, ModelProperty<out Model, *>>(
            StrategyData.AVG_BID to StrategyWithAvgBid.AVG_BID,
            StrategyData.AVG_CPA to StrategyWithAvgCpa.AVG_CPA,
            StrategyData.AVG_CPV to StrategyWithAvgCpv.AVG_CPV,
            StrategyData.PAY_FOR_CONVERSION to StrategyWithPayForConversion.IS_PAY_FOR_CONVERSION_ENABLED,
            StrategyData.AVG_CPI to AutobudgetAvgCpi.AVG_CPI,
            StrategyData.AVG_CPM to StrategyWithAvgCpm.AVG_CPM,
            StrategyData.FILTER_AVG_BID to AutobudgetAvgCpcPerFilter.FILTER_AVG_BID,
            StrategyData.FILTER_AVG_CPA to AutobudgetAvgCpaPerFilter.FILTER_AVG_CPA,
            StrategyData.BID to StrategyWithBid.BID,
            StrategyData.SUM to StrategyWithWeeklyBudget.SUM,
            StrategyData.BUDGET to StrategyWithCustomPeriodBudget.BUDGET,
            StrategyData.CRR to AutobudgetCrr.CRR,
            StrategyData.GOAL_ID to StrategyWithConversion.GOAL_ID,
            StrategyData.ROI_COEF to AutobudgetRoi.ROI_COEF,
            StrategyData.PROFITABILITY to AutobudgetRoi.PROFITABILITY,
            StrategyData.RESERVE_RETURN to AutobudgetRoi.RESERVE_RETURN,
            StrategyData.LIMIT_CLICKS to AutobudgetWeekBundle.LIMIT_CLICKS,
            StrategyData.START to StrategyWithCustomPeriodBudget.START,
            StrategyData.FINISH to StrategyWithCustomPeriodBudget.FINISH,
            StrategyData.DATE to AutobudgetMedia.DATE
        )

    @JvmStatic
    fun isModelChangesAffectsStrategy(mc: ModelChanges<out CampaignWithPackageStrategy>): Boolean =
        mc.changedPropsNames.find(CampaignModelPropertiesAffectsStrategy::contains) != null

    @JvmStatic
    fun isNotModelChangesAffectsStrategy(
        mc: ModelChanges<out CampaignWithPackageStrategy>,
        strategy: BaseStrategy
    ): Boolean {
        val changedProps =
            mc.changedPropsNames as? Set<ModelProperty<in CampaignWithPackageStrategy, *>> ?: emptySet()
        return changedProps.fold(true) { result, modelProperty ->
            if (modelProperty != CampaignWithStrategy.STRATEGY) {
                result && isEqual(mc, strategy, modelProperty)
            } else {
                val dbStrategy = mc.getPropIfChanged(modelProperty) as? DbStrategy
                val strategyData = dbStrategy?.strategyData
                result && (strategyData == null || isEqualStrategyData(strategyData, strategy))
            }
        }
    }

    private fun isEqualStrategyData(
        strategyData: StrategyData,
        strategy: BaseStrategy
    ): Boolean {
        return StrategyData.allModelProperties().fold(true) { result, prop ->
            val value = prop.get(strategyData)
            val strategyModelProperty =
                CampaignStrategyPropertiesAffectsStrategyMapping[prop] as? ModelProperty<Model, Any>
            result && (strategyModelProperty == null || isEqual(
                strategyModelProperty,
                strategy,
                value
            ))
        }
    }

    private fun <V> isEqual(
        strategyProp: ModelProperty<Model, V>,
        strategy: BaseStrategy,
        campaignPropValue: V?
    ): Boolean {
        val isModelPropertyRefersToStrategy =
            strategyProp.modelClass.isAssignableFrom(strategy::class.java)
        val strategyValue = if (isModelPropertyRefersToStrategy) {
            strategyProp.get(strategy)
        } else {
            null
        }
        return arePropertyValuesEquals(
            strategyProp,
            campaignPropValue,
            strategyValue
        )
    }

    private fun <T : CampaignWithPackageStrategy, V> isEqual(
        mc: ModelChanges<T>,
        strategy: BaseStrategy,
        modelProperty: ModelProperty<in CampaignWithPackageStrategy, V>
    ): Boolean {
        val mcValue: V? = mc.getChangedProp(modelProperty)
        val strategyModelProperty = CampaignModelPropertiesAffectsStrategyMapping[modelProperty] as?
            ModelProperty<Model, V>
        return strategyModelProperty == null || isEqual(
            strategyModelProperty,
            strategy,
            mcValue
        )
    }
}
