package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class CampaignWithPlacementTypesValidator implements Validator<CampaignWithPlacementTypes, Defect> {
    @Override
    public ValidationResult<CampaignWithPlacementTypes, Defect> apply(CampaignWithPlacementTypes campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithPlacementTypes.PLACEMENT_TYPES)
                .check(notNull());
        return vb.getResult();
    }
}
