package ru.yandex.direct.core.entity.campaign.service.validation.type.bean

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPromoExtension
import ru.yandex.direct.core.entity.campaign.service.validation.type.add.AbstractCampaignAddValidationTypeSupport
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer
import ru.yandex.direct.core.entity.campaign.service.validation.type.update.AbstractCampaignUpdateValidationTypeSupport
import ru.yandex.direct.core.entity.promoextension.PromoExtensionRepository
import ru.yandex.direct.validation.builder.Constraint.fromPredicate
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.item
import ru.yandex.direct.validation.util.validateModel

class CampaignWithPromoExtensionValidator(
    private val clientPromoExtensionIds: Set<Long>,
) : Validator<CampaignWithPromoExtension, Defect<*>> {
    override fun apply(campaign: CampaignWithPromoExtension): ValidationResult<CampaignWithPromoExtension, Defect<*>> {
        return validateModel(campaign) {
            item(CampaignWithPromoExtension.PROMO_EXTENSION_ID) {
                check(fromPredicate(
                    { promoExtensionId -> clientPromoExtensionIds.contains(promoExtensionId) },
                    CommonDefects.objectNotFound()
                ))
            }
        }
    }
}

@Component
class CampaignWithPromoExtensionAddValidationTypeSupport(
    private val promoExtensionRepository: PromoExtensionRepository,
) : AbstractCampaignAddValidationTypeSupport<CampaignWithPromoExtension>() {
    override fun getTypeClass(): Class<CampaignWithPromoExtension> {
        return CampaignWithPromoExtension::class.java
    }

    override fun validate(
        container: CampaignValidationContainer,
        vr: ValidationResult<List<CampaignWithPromoExtension>, Defect<*>>
    ): ValidationResult<List<CampaignWithPromoExtension>, Defect<*>> {
        val vb = ListValidationBuilder(vr)
        val validator = CampaignWithPromoExtensionValidator(promoExtensionRepository.getAllClientPromoExtensionIds(container.shard, container.clientId))
        vb.checkEachBy(validator)
        return vb.result
    }
}

@Component
class CampaignWithPromoExtensionUpdateValidationTypeSupport(
    private val promoExtensionRepository: PromoExtensionRepository,
) : AbstractCampaignUpdateValidationTypeSupport<CampaignWithPromoExtension>() {
    override fun getTypeClass(): Class<CampaignWithPromoExtension> {
        return CampaignWithPromoExtension::class.java
    }

    override fun validate(
        container: CampaignValidationContainer,
        vr: ValidationResult<List<CampaignWithPromoExtension>, Defect<*>>
    ): ValidationResult<List<CampaignWithPromoExtension>, Defect<*>> {
        val vb = ListValidationBuilder(vr)
        val validator = CampaignWithPromoExtensionValidator(promoExtensionRepository.getAllClientPromoExtensionIds(container.shard, container.clientId))
        vb.checkEachBy(validator)
        return vb.result
    }
}
