package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignMetatype;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithRecommendationsManagement;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@SuppressWarnings("rawtypes")
public class CampaignWithRecommendationsManagementPreValidator
        implements Validator<CampaignWithRecommendationsManagement, Defect> {

    @Override
    @SuppressWarnings("java:S3252")
    public ValidationResult<CampaignWithRecommendationsManagement, Defect> apply(
            CampaignWithRecommendationsManagement campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);

        // в товарных кампаниях нельзя ставить recommendationsManagementEnabled
        vb.item(CampaignWithRecommendationsManagement.IS_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .check(Constraint.fromPredicate(recommendationsManagementEnabled ->
                                !Boolean.TRUE.equals(recommendationsManagementEnabled)
                                        || campaign.getMetatype() != CampaignMetatype.ECOM,
                    CommonDefects.inconsistentState()
                ), When.notNull());

        // не разрешаем сочетание priceRecommendationsManagementEnabled = true, recommendationsManagementEnabled = false
        var recommendationsManagementEnabled = campaign.getIsRecommendationsManagementEnabled();
        vb.item(CampaignWithRecommendationsManagement.IS_PRICE_RECOMMENDATIONS_MANAGEMENT_ENABLED)
                .check(Constraint.fromPredicate(priceRecommendationsManagementEnabled ->
                                !priceRecommendationsManagementEnabled
                                || Boolean.TRUE.equals(recommendationsManagementEnabled),
                    CommonDefects.inconsistentState()
                ), When.notNullAnd(When.isTrue(!vb.getResult().hasAnyErrors())));

        return vb.getResult();
    }
}
