package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithRequireFiltrationByDontShowDomainsForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalRequireFiltrationByDontShowDomainsValidator.UNVERIFIABLE_CAMPAIGN_TYPES;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithRequireFiltrationByDontShowDomainsForbiddenValidator
        implements Validator<CampaignWithRequireFiltrationByDontShowDomainsForbidden, Defect> {

    @Override
    public ValidationResult<CampaignWithRequireFiltrationByDontShowDomainsForbidden, Defect> apply(
            CampaignWithRequireFiltrationByDontShowDomainsForbidden campaign) {

        var vb = ModelItemValidationBuilder.of(campaign);

        vb.item(CampaignWithRequireFiltrationByDontShowDomainsForbidden.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS)
                .check(isNull(), When.isFalse(UNVERIFIABLE_CAMPAIGN_TYPES.contains(campaign.getType())))
                // TODO (dimitrovsd): оторвать этот грязный костыль после закрытия старого интерфейса
                .check(fromPredicate(requireFiltrationByDontShowDomains -> !requireFiltrationByDontShowDomains,
                        CommonDefects.isNull()), When.isTrue(UNVERIFIABLE_CAMPAIGN_TYPES.contains(campaign.getType())));

        return vb.getResult();
    }
}
