package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSimplifiedStrategyViewForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithSimplifiedStrategyViewForbiddenValidator
        implements Validator<CampaignWithSimplifiedStrategyViewForbidden, Defect> {

    @Override
    public ValidationResult<CampaignWithSimplifiedStrategyViewForbidden, Defect> apply(
            CampaignWithSimplifiedStrategyViewForbidden campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithSimplifiedStrategyViewForbidden.IS_SIMPLIFIED_STRATEGY_VIEW_ENABLED)
                .check(isNull());
        return vb.getResult();
    }

}
