package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSiteMonitoring;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class CampaignWithSiteMonitoringValidator implements Validator<CampaignWithSiteMonitoring, Defect> {

    @Override
    public ValidationResult<CampaignWithSiteMonitoring, Defect> apply(CampaignWithSiteMonitoring campaign) {
        ModelItemValidationBuilder<CampaignWithSiteMonitoring> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithSiteMonitoring.HAS_SITE_MONITORING)
                .check(notNull());
        return vb.getResult();
    }

}
