package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTurboApp;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

public class CampaignWithTurboAppValidator {

    private final boolean canEnableTurboApps;

    public CampaignWithTurboAppValidator(boolean canEnableTurboApps) {
        this.canEnableTurboApps = canEnableTurboApps;
    }

    public ValidationResult<CampaignWithTurboApp, Defect> apply(CampaignWithTurboApp campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);

        vb.item(CampaignWithTurboApp.HAS_TURBO_APP)
                .check(notTrue(), When.notNullAnd(When.isFalse(canEnableTurboApps)));

        return vb.getResult();
    }

    public ValidationResult<ModelChanges<CampaignWithTurboApp>, Defect> applyForModelChanges(ModelChanges<CampaignWithTurboApp> modelChanges) {
        var vb = ModelItemValidationBuilder.<ModelChanges<CampaignWithTurboApp>, Defect>of(modelChanges);

        vb.check(Constraint.fromPredicate(mc -> !mc.isPropChanged(CampaignWithTurboApp.HAS_TURBO_APP) ||
                        !Boolean.TRUE.equals(mc.getChangedProp(CampaignWithTurboApp.HAS_TURBO_APP)), invalidValue()),
                When.isFalse(canEnableTurboApps));

        return vb.getResult();
    }
}
