package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithWwManagedOrderFlag;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

public class CampaignWithWwManagedOrderFlagValidator implements Validator<CampaignWithWwManagedOrderFlag, Defect> {

    private final boolean isWwManagedOrderEnabled;

    public CampaignWithWwManagedOrderFlagValidator(boolean isWwManagedOrderEnabled) {
        this.isWwManagedOrderEnabled = isWwManagedOrderEnabled;
    }

    @Override
    public ValidationResult<CampaignWithWwManagedOrderFlag, Defect> apply(CampaignWithWwManagedOrderFlag campaign) {
        ModelItemValidationBuilder<CampaignWithWwManagedOrderFlag> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithWwManagedOrderFlag.IS_WW_MANAGED_ORDER)
                .check(notTrue(), When.isFalse(isWwManagedOrderEnabled));
        return vb.getResult();
    }
}
