package ru.yandex.direct.core.entity.campaign.service.validation.type.bean

import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate
import ru.yandex.direct.core.entity.campaign.model.ExternalCampaignWithImpressionRate
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class ExternalCampaignWithImpressionRateValidator : Validator<ExternalCampaignWithImpressionRate, Defect<*>> {
    override fun apply(campaign: ExternalCampaignWithImpressionRate?)
    : ValidationResult<ExternalCampaignWithImpressionRate, Defect<*>> {
        val vb = ModelItemValidationBuilder.of<ExternalCampaignWithImpressionRate>(campaign)

        vb.item(CampaignWithImpressionRate.IMPRESSION_RATE_INTERVAL_DAYS)
            .check(NumberConstraints.inRange(1, CampaignConstants.MAX_IMPRESSION_RATE_INTERVAL_DAYS), When.notNull())

        return vb.result
    }
}