package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@ParametersAreNonnullByDefault
public class InternalCampaignCommonValidator implements Validator<InternalCampaign, Defect> {

    @Override
    public ValidationResult<InternalCampaign, Defect> apply(InternalCampaign campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(InternalCampaign.PAGE_ID)
                .check(notNull())
                .checkBy(pageIds -> ListValidationBuilder.<Long, Defect>of(pageIds)
                        .checkEach(notNull())
                        .checkEach(validId(), When.notNull())
                        .getResult());
        vb.item(InternalCampaign.IS_MOBILE)
                .check(notNull());
        return vb.getResult();
    }

}
