package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithImpressionRate;
import ru.yandex.direct.core.entity.campaign.model.RfCloseByClickType;
import ru.yandex.direct.core.validation.validators.ModelWithInternalImpressionRateValidator;

@ParametersAreNonnullByDefault
public class InternalCampaignWithImpressionRateValidator extends
        ModelWithInternalImpressionRateValidator<InternalCampaignWithImpressionRate> {

    public InternalCampaignWithImpressionRateValidator(@Nullable RfCloseByClickType rfCloseByClickType,
                                                       List<Long> bannerWithCloseCounterVarIds) {
        super(InternalCampaignWithImpressionRate.IMPRESSION_RATE_COUNT,
                InternalCampaignWithImpressionRate.IMPRESSION_RATE_INTERVAL_DAYS,
                InternalCampaignWithImpressionRate.MAX_CLICKS_COUNT,
                InternalCampaignWithImpressionRate.MAX_CLICKS_PERIOD,
                InternalCampaignWithImpressionRate.MAX_STOPS_COUNT,
                InternalCampaignWithImpressionRate.MAX_STOPS_PERIOD,
                rfCloseByClickType, bannerWithCloseCounterVarIds);
    }

}
