package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRequiredRotationGoalId;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRotationGoalId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class InternalCampaignWithRequiredRotationGoalIdValidator
        implements Validator<InternalCampaignWithRequiredRotationGoalId, Defect> {

    private static final InternalCampaignWithRotationGoalIdValidator<InternalCampaignWithRequiredRotationGoalId>
            COMMON_ROTATION_GOAL_ID_VALIDATOR = new InternalCampaignWithRotationGoalIdValidator<>();

    @Override
    public ValidationResult<InternalCampaignWithRequiredRotationGoalId, Defect> apply(
            InternalCampaignWithRequiredRotationGoalId campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(InternalCampaignWithRotationGoalId.ROTATION_GOAL_ID)
                .check(notNull());
        vb.checkBy(COMMON_ROTATION_GOAL_ID_VALIDATOR, When.isValid());
        return vb.getResult();
    }

}
