package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignRestrictionType;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRestriction;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MIN_INTERNAL_CAMPAIGN_RESTRICTION_VALUE;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan;

@ParametersAreNonnullByDefault
public class InternalCampaignWithRestrictionValidator
        implements Validator<InternalCampaignWithRestriction, Defect> {

    // от InternalCampaignRestrictionType.MONEY есть план отказаться совсем
    private static final Set<InternalCampaignRestrictionType> ALLOWED_RESTRICTION_TYPES =
            Set.of(InternalCampaignRestrictionType.SHOWS, InternalCampaignRestrictionType.CLICKS,
                    InternalCampaignRestrictionType.DAYS);

    @Override
    public ValidationResult<InternalCampaignWithRestriction, Defect> apply(
            InternalCampaignWithRestriction campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(InternalCampaignWithRestriction.RESTRICTION_VALUE)
                .check(notNull())
                .check(notLessThan(MIN_INTERNAL_CAMPAIGN_RESTRICTION_VALUE));
        vb.item(InternalCampaignWithRestriction.RESTRICTION_TYPE)
                .check(notNull())
                .check(inSet(ALLOWED_RESTRICTION_TYPES));
        return vb.getResult();
    }

}
