package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRotationGoalId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MIN_INTERNAL_CAMPAIGN_ROTATION_GOAL_ID;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notEqual;
import static ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan;

@ParametersAreNonnullByDefault
public class InternalCampaignWithRotationGoalIdValidator<T extends InternalCampaignWithRotationGoalId>
        implements Validator<T, Defect> {

    public static final long MOBILE_ROTATION_GOAL_ID = 3L;

    @Override
    public ValidationResult<T, Defect> apply(T campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(InternalCampaignWithRotationGoalId.ROTATION_GOAL_ID)
                .check(notLessThan(MIN_INTERNAL_CAMPAIGN_ROTATION_GOAL_ID))
                .check(notEqual(MOBILE_ROTATION_GOAL_ID, CommonDefects.inconsistentState()),
                        When.isFalse(campaign.getIsMobile()));
        return vb.getResult();
    }

}
