package ru.yandex.direct.core.entity.campaign.service.validation.type.bean.meaningfulgoals;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.ENGAGED_SESSION_GOAL_ID;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nullableNvl;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;

public class CampaignWithMeaningfulGoalsConversionValueBeforeApplyValidator
        implements Validator<ModelChanges<CampaignWithMeaningfulGoalsWithRequiredFields>, Defect> {

    private final CampaignWithMeaningfulGoalsWithRequiredFields currentCampaign;

    private CampaignWithMeaningfulGoalsConversionValueBeforeApplyValidator(CampaignWithMeaningfulGoalsWithRequiredFields currentCampaign) {
        this.currentCampaign = currentCampaign;
    }

    public static CampaignWithMeaningfulGoalsConversionValueBeforeApplyValidator build(CampaignWithMeaningfulGoalsWithRequiredFields currentCampaign) {
        return new CampaignWithMeaningfulGoalsConversionValueBeforeApplyValidator(currentCampaign);
    }

    @Override
    public ValidationResult<ModelChanges<CampaignWithMeaningfulGoalsWithRequiredFields>, Defect> apply(
            ModelChanges<CampaignWithMeaningfulGoalsWithRequiredFields> campaignChanges) {
        var vb = ItemValidationBuilder.of(campaignChanges, Defect.class);

        CurrencyCode currencyCode = getCurrencyCode(campaignChanges, currentCampaign);

        if (currencyCode == null) {
            return vb.getResult();
        }

        vb.list(campaignChanges.getPropIfChanged(CampaignWithMeaningfulGoalsWithRequiredFields.MEANINGFUL_GOALS),
                CampaignWithMeaningfulGoalsWithRequiredFields.MEANINGFUL_GOALS.name())
                .checkEachBy(
                        goal -> MeaningfulGoalWithConversionValueValidator.build(currencyCode.getCurrency()).apply(goal),
                        When.notNull());
        return vb.getResult();
    }

    @Nullable
    public static CurrencyCode getCurrencyCode(ModelChanges<CampaignWithMeaningfulGoalsWithRequiredFields> campaignChanges,
                                                CampaignWithMeaningfulGoalsWithRequiredFields currentCampaign) {
        return nullableNvl(
                campaignChanges.getPropIfChanged(CampaignWithMeaningfulGoalsWithRequiredFields.CURRENCY),
                ifNotNull(currentCampaign, CampaignWithMeaningfulGoalsWithRequiredFields::getCurrency));
    }

    public static class MeaningfulGoalWithConversionValueValidator implements Validator<MeaningfulGoal, Defect> {
        private final Currency currency;

        private MeaningfulGoalWithConversionValueValidator(Currency currency) {
            this.currency = currency;
        }

        public static MeaningfulGoalWithConversionValueValidator build(Currency currency) {
            return new MeaningfulGoalWithConversionValueValidator(currency);
        }

        @Override
        public ValidationResult<MeaningfulGoal, Defect> apply(MeaningfulGoal meaningfulGoal) {
            var vb = ModelItemValidationBuilder.of(meaningfulGoal);
            vb.item(MeaningfulGoal.CONVERSION_VALUE)
                    .check(notNull(), When.isFalse(meaningfulGoal.getGoalId() != null &&
                            ENGAGED_SESSION_GOAL_ID == meaningfulGoal.getGoalId()))
                    .check(inRange(currency.getMinPrice(), currency.getMaxAutobudget()));
            return vb.getResult();
        }
    }
}
