package ru.yandex.direct.core.entity.campaign.service.validation.type.bean.utils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.campaignStrategyInfoIsIgnoredOnCampaignAdd;
import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.campaignStrategyInfoIsIgnoredOnCampaignUpdate;
import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.newStrategyHasBeenCreated;

public class CampaignValidationUtils {
    private final static Set<Defect> CAMPAIGN_WITH_PACKAGE_STRATEGY_VALIDATION_DEFECTS = Set.of(
            campaignStrategyInfoIsIgnoredOnCampaignAdd(),
            newStrategyHasBeenCreated(),
            campaignStrategyInfoIsIgnoredOnCampaignUpdate()
    );

    public static <T> ValidationResult<T, Defect> eraseSpecificWarningsIfErrors(ValidationResult<T, Defect> vr) {
        if (vr.hasAnyErrors()) {
            var transformer =
                    new SpecifiedWarningsErasingValidationResultTransformer<>(
                            CAMPAIGN_WITH_PACKAGE_STRATEGY_VALIDATION_DEFECTS
                    );
            return vr.transformUnchecked(transformer);
        } else {
            return vr;
        }
    }

    @ParametersAreNonnullByDefault
    static class SpecifiedWarningsErasingValidationResultTransformer<D> implements ValidationResult.ValidationResultTransformer<D> {
        private final Set<D> warningsToRemove;

        SpecifiedWarningsErasingValidationResultTransformer(Set<D> warningsToRemove) {
            this.warningsToRemove = warningsToRemove;
        }

        @Override
        public List<D> transformWarnings(Path path, List<D> warnings) {
            return warnings
                    .stream()
                    .filter(warning -> !warningsToRemove.contains(warning))
                    .collect(Collectors.toList());
        }
    }
}
