package ru.yandex.direct.core.entity.campaign.service.validation.type.bean.utils;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.model.StrategyName;
import ru.yandex.direct.core.entity.strategy.service.StrategyConstants;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.publicStrategyNotSupportedForClientsWithoutWallet;
import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.tooMuchCampaignsLinkedToStrategy;
import static ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.unavailableStrategyTypeForPublication;

public class CampaignWithPackageStrategyValidatorUtils {

    public static Constraint<Long, Defect> maxNumberOfCidsNotExceeded(int potentialNumberOfLinkedCids,
                                                                      int maxNumberOfLinkedCids) {
        return Constraint.fromPredicate(
                campaign -> potentialNumberOfLinkedCids <= maxNumberOfLinkedCids,
                tooMuchCampaignsLinkedToStrategy(maxNumberOfLinkedCids));
    }

    public static Constraint<CampaignWithPackageStrategy, Defect> hasWallet() {
        return Constraint.fromPredicate(
                campaign -> campaign.getWalletId() != 0,
                publicStrategyNotSupportedForClientsWithoutWallet());
    }

    public static Constraint<CampaignWithPackageStrategy, Defect> strategyIsAvailableForPublication(StrategyName strategyType) {
        return Constraint.fromPredicate(
                campaign -> StrategyConstants.AVAILABLE_STRATEGY_TYPES_FOR_PUBLIC_STRATEGY.contains(strategyType),
                unavailableStrategyTypeForPublication());
    }

    public static boolean isNonPublic(CommonStrategy strategy) {
        return strategy.getIsPublic() == null || !strategy.getIsPublic();
    }
}
