package ru.yandex.direct.core.entity.campaign.service.validation.type.container;

import java.util.Map;

import javax.annotation.Nullable;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;

import static java.util.Collections.emptyMap;

public interface CampaignValidationContainer extends UpdateOperationContainer<BaseCampaign> {

    @Deprecated
    @VisibleForTesting
    static CampaignValidationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId) {
        return new CampaignValidationContainerImpl(shard, operatorUid, clientId, null, new CampaignOptions(), null,
                emptyMap());
    }

    int getShard();

    Long getOperatorUid();

    ClientId getClientId();

    Long getChiefUid();

    CampaignOptions getOptions();

    boolean isCopy();

    CampaignType getCampaignType(Long campaignId);

    boolean skipValidateMobileApp();

    RequestBasedMetrikaClientAdapter getMetrikaClient();

    Boolean getRequireServicing(BaseCampaign campaign);

    /**
     * Возвращает мапу goalId на counterId.
     * Но не для всех кампаний из запроса, а только для тех, у которых goalId был указан, а counterId при этом не
     * указан (иначе можно использовать counterId, который стоит на самой кампании)
     */
    Map<Long, Long> getGoalIdToCounterIdForCampaignsWithoutCounterIds();

    /**
     * Возвращает стратегию из списка: доступные стратегии, к которым клиент хочет прилинковать кампании;
     * стратегии, к которым прилинкованы изменяемые кампании сейчас.
     */
    @Nullable
    BaseStrategy getPackageStrategy(Long strategyId);

    DisabledFieldsDataContainer getDisabledFieldsInfoContainer();

}
