package ru.yandex.direct.core.entity.campaign.service.validation.type.container;

import java.util.Map;

import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Collections.emptyMap;

/**
 * Этот класс существует по двум причинам:
 * - не хотелось менять 100500 тестов, которые создают контейнер
 * - есть мысль, что в будущем захотим вызывать валидацию отдельно, без операции, а тогда отдельный валидационный
 *   контейнер может быть действительно понадобится.
 * Иначе в идеале от этого класса нужно избавиться.
 */
@VisibleForTesting
public class CampaignValidationContainerImpl implements CampaignValidationContainer {

    private final int shard;
    private final Long operatorUid;
    private final ClientId clientId;
    private final Long chiefUid;
    private final CampaignOptions options;
    private final RequestBasedMetrikaClientAdapter metrikaClientAdapter;
    private final Map<Long, BaseStrategy> packageStrategyFromOperationAndOperationCampaignsById;
    private final DisabledFieldsDataContainer disabledDataContainer;

    public CampaignValidationContainerImpl(int shard, Long operatorUid, ClientId clientId, Long chiefUid,
                                           CampaignOptions options,
                                           RequestBasedMetrikaClientAdapter metrikaClientAdapter,
                                           Map<Long, BaseStrategy> packageStrategyFromOperationAndOperationCampaignsById) {
        this(shard, operatorUid, clientId, chiefUid, options, metrikaClientAdapter,
                packageStrategyFromOperationAndOperationCampaignsById, new DisabledFieldsDataContainer());
    }

    public CampaignValidationContainerImpl(int shard, Long operatorUid, ClientId clientId, Long chiefUid,
                                           CampaignOptions options,
                                           RequestBasedMetrikaClientAdapter metrikaClientAdapter,
                                           Map<Long, BaseStrategy> packageStrategyFromOperationAndOperationCampaignsById,
                                           DisabledFieldsDataContainer disabledDataContainer) {
        this.shard = shard;
        this.operatorUid = operatorUid;
        this.clientId = clientId;
        this.chiefUid = chiefUid;
        this.options = options;
        this.metrikaClientAdapter = metrikaClientAdapter;
        this.packageStrategyFromOperationAndOperationCampaignsById =
                packageStrategyFromOperationAndOperationCampaignsById;
        this.disabledDataContainer = disabledDataContainer;
    }

    @Override
    public int getShard() {
        return shard;
    }

    @Override
    public Long getOperatorUid() {
        return operatorUid;
    }

    @Override
    public ClientId getClientId() {
        return clientId;
    }

    @Override
    public Long getChiefUid() {
        return chiefUid;
    }

    @Override
    public CampaignOptions getOptions() {
        return options;
    }

    @Override
    public boolean isCopy() {
        return options.isCopy();
    }

    @Override
    public CampaignType getCampaignType(Long campaignId) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Class<? extends BaseCampaign> getRuntimeClass(@NotNull Long modelId) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean skipValidateMobileApp() {
        return options.getSkipValidateMobileApp();
    }

    @Override
    public RequestBasedMetrikaClientAdapter getMetrikaClient() {
        return metrikaClientAdapter;
    }

    @Override
    public Boolean getRequireServicing(BaseCampaign campaign) {
        return Boolean.FALSE;
    }

    @Override
    public Map<Long, Long> getGoalIdToCounterIdForCampaignsWithoutCounterIds() {
        return emptyMap();
    }

    @Override
    public BaseStrategy getPackageStrategy(Long strategyId) {
        return packageStrategyFromOperationAndOperationCampaignsById.get(strategyId);
    }

    @Override
    public DisabledFieldsDataContainer getDisabledFieldsInfoContainer() {
        return disabledDataContainer;
    }

}
