package ru.yandex.direct.core.entity.campaign.service.validation.type.disabled;

import java.math.BigDecimal;
import java.util.Optional;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategyBase;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.WithStrategy;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

@Component
public class CampaignUpdateStrategyLimitValidationTypeSupport
        extends AbstractCampaignUpdateDisabledFieldValidationTypeSupport<CampaignWithStrategy> {

    @Override
    public Class<CampaignWithStrategy> getTypeClass() {
        return CampaignWithStrategy.class;
    }

    @Override
    DisabledField getCheckField() {
        return DisabledField.CAMP_BUDGET_SUM;
    }

    @Override
    public ModelProperty<? super CampaignWithStrategy, ?> getChanged(
            AppliedChanges<CampaignWithStrategy> changes
    ) {
        if (!changes.changed(WithStrategy.STRATEGY)) {
            return null;
        }
        var newValue = getSum(changes.getNewValue(WithStrategy.STRATEGY));
        var oldValue = getSum(changes.getOldValue(WithStrategy.STRATEGY));
        return newValue == oldValue ? null : WithStrategy.STRATEGY;
    }

    private static long getSum(DbStrategy strategy) {
        return Optional.ofNullable(strategy)
                .map(DbStrategyBase::getStrategyData)
                .map(StrategyData::getSum)
                .map(BigDecimal::longValue)
                .orElse(0L);
    }
}
