package ru.yandex.direct.core.entity.campaign.service.validation.type.disabled;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisabledFieldsDataContainer {

    private static final Logger logger = LoggerFactory.getLogger(DisabledFieldsDataContainer.class);

    private final Collection<Long> canContainedDisabledFieldEntityIds;
    private Map<Long, Map<DisabledField, Object>> disabledData = null;

    public DisabledFieldsDataContainer() {
        this(null);
    }

    public DisabledFieldsDataContainer(Collection<Long> canContainedDisabledFieldEntityIds) {
        this.canContainedDisabledFieldEntityIds = canContainedDisabledFieldEntityIds;
    }

    boolean canObjectHaveDisabledFields(Long entityId) {
        return canContainedDisabledFieldEntityIds == null ||
                canContainedDisabledFieldEntityIds.contains(entityId);
    }

    Object getDisabledFieldInfo(
            Long entityId, DisabledField field,
            Function<Collection<Long>, Map<Long, Map<DisabledField, Object>>> dataSupplier) {
        if (canContainedDisabledFieldEntityIds == null) {
            logger.error("На объекте " + entityId + " менялось поле " + field + " без валидации доступности.");
            // Если увидели это сообщение в логах, значит нашелся кейс, где не добавляем в контейнер список объектов,
            // для которых требуется проверка. Нужно поправить заполнение контейнера, иначе пользователь сможет менять
            // поле, которое управляется автоматическими рекомендациями.
            return null;
        }
        if (disabledData == null) {
            disabledData = dataSupplier.apply(canContainedDisabledFieldEntityIds);
        }
        return disabledData.getOrDefault(entityId, Collections.emptyMap()).get(field);
    }
}
