package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignForbiddenOnTouch;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignForbiddenOnTouchUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignForbiddenOnTouch> {

    @Autowired
    public CampaignForbiddenOnTouchUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignForbiddenOnTouch> getTypeClass() {
        return CampaignForbiddenOnTouch.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignForbiddenOnTouch>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignForbiddenOnTouch>>, Defect> vr) {
        forEachModelChangesAddDefectIfFieldChanged(vr, CampaignForbiddenOnTouch.IS_TOUCH);
        return vr;
    }

}
