package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignSupportedOnTouch;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignSupportedOnTouchValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.validation.defects.RightsDefects.noRights;

@Component
@ParametersAreNonnullByDefault
public class CampaignSupportedOnTouchUpdateValidationTypeSupport extends
        AbstractCampaignUpdateValidationTypeSupport<CampaignSupportedOnTouch> {

    private final FeatureService featureService;
    private final RbacService rbacService;

    @Autowired
    public CampaignSupportedOnTouchUpdateValidationTypeSupport(FeatureService featureService, RbacService rbacService) {
        this.featureService = featureService;
        this.rbacService = rbacService;
    }

    @Override
    public Class<CampaignSupportedOnTouch> getTypeClass() {
        return CampaignSupportedOnTouch.class;
    }


    @Override
    public ValidationResult<List<ModelChanges<CampaignSupportedOnTouch>>, Defect> validateBeforeApply(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignSupportedOnTouch>>, Defect> vr,
            Map<Long, CampaignSupportedOnTouch> unmodifiedModels
    ) {
        RbacRole userRole = rbacService.getUidRole(container.getOperatorUid());

        Validator<ModelChanges<CampaignSupportedOnTouch>, Defect> validator = changes -> {
            ItemValidationBuilder<ModelChanges<CampaignSupportedOnTouch>, Defect> vb =
                    ItemValidationBuilder.of(changes);

            var unmodifiedModel = unmodifiedModels.get(changes.getId());
            if (unmodifiedModel == null) {
                return vb.getResult();
            }

            vb.item(
                    changes.getPropIfChanged(CampaignSupportedOnTouch.IS_TOUCH),
                    CampaignSupportedOnTouch.IS_TOUCH.name()
            ).check(
                    Constraint.fromPredicate(
                            val -> val == null || val.equals(unmodifiedModel.getIsTouch()),
                            noRights()),
                    When.isFalse(userRole.isInternal())
            );

            return vb.getResult();
        };

        return new ListValidationBuilder<>(vr).checkEachBy(validator, When.isValid()).getResult();
    }

    @Override
    public ValidationResult<List<CampaignSupportedOnTouch>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignSupportedOnTouch>, Defect> vr) {

        boolean isTouchDirectEnabled = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.TOUCH_DIRECT_ENABLED);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignSupportedOnTouchValidator(isTouchDirectEnabled).apply(campaign))
                .getResult();
    }

}
