package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataHref;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAdditionalDataHrefValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataHrefUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithAdditionalDataHref> {

    @Autowired
    CampaignWithAdditionalDataHrefUpdateValidationTypeSupport() {
    }

    @Override
    public Class<CampaignWithAdditionalDataHref> getTypeClass() {
        return CampaignWithAdditionalDataHref.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAdditionalDataHref>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAdditionalDataHref>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAdditionalDataHrefValidator())
                .getResult();
    }
}
