package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContentForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentForbiddenUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithAllowedOnAdultContentForbidden> {

    @Override
    public Class<CampaignWithAllowedOnAdultContentForbidden> getTypeClass() {
        return CampaignWithAllowedOnAdultContentForbidden.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithAllowedOnAdultContentForbidden>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithAllowedOnAdultContentForbidden>>, Defect> vr
    ) {
        forEachModelChangesAddDefectIfFieldChanged(
                vr, CampaignWithAllowedOnAdultContentForbidden.IS_ALLOWED_ON_ADULT_CONTENT);
        return vr;
    }
}
