package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.forEachModelChangesAddDefectIfFieldChanged;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithAllowedOnAdultContent> {

    private final FeatureService featureService;

    public CampaignWithAllowedOnAdultContentUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithAllowedOnAdultContent> getTypeClass() {
        return CampaignWithAllowedOnAdultContent.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithAllowedOnAdultContent>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithAllowedOnAdultContent>>, Defect> vr
    ) {
        var isAllowedOnAdultContentEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.CAMPAIGN_ALLOWED_ON_ADULT_CONTENT);

        if (!isAllowedOnAdultContentEnabled) {
            forEachModelChangesAddDefectIfFieldChanged(vr, CampaignWithAllowedOnAdultContent.IS_ALLOWED_ON_ADULT_CONTENT);
        }

        return vr;
    }
}
