package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedPageIds;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAllowedPageIdsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.operatorCannotSetAllowedPageIds;
import static ru.yandex.direct.multitype.service.validation.type.ValidationTypeSupportUtils.addDefectOnField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedPageIdsUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithAllowedPageIds> {

    private final FeatureService featureService;
    private final SspPlatformsRepository sspPlatformsRepository;

    @Autowired
    public CampaignWithAllowedPageIdsUpdateValidationTypeSupport(FeatureService featureService,
                                                                 SspPlatformsRepository sspPlatformsRepository) {
        this.featureService = featureService;
        this.sspPlatformsRepository = sspPlatformsRepository;
    }

    @Override
    public Class<CampaignWithAllowedPageIds> getTypeClass() {
        return CampaignWithAllowedPageIds.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<CampaignWithAllowedPageIds>>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<ModelChanges<CampaignWithAllowedPageIds>>, Defect> vr) {
        List<ModelChanges<CampaignWithAllowedPageIds>> modelChanges = vr.getValue();
        if (!featureService.isEnabledForUid(container.getOperatorUid(), List.of(FeatureName.SET_CAMPAIGN_ALLOWED_PAGE_IDS))) {
            for (int i = 0; i < modelChanges.size(); i++) {
                if (isAllowedPageIdsChanged(modelChanges.get(i))) {
                    addDefectOnField(vr, CampaignWithAllowedPageIds.ALLOWED_PAGE_IDS, i,
                            operatorCannotSetAllowedPageIds());
                }
                if (modelChanges.get(i).isPropChanged(CampaignWithAllowedPageIds.ALLOWED_DOMAINS)) {
                    addDefectOnField(vr, CampaignWithAllowedPageIds.ALLOWED_DOMAINS, i,
                            operatorCannotSetAllowedPageIds());
                }
            }
        }
        return vr;
    }

    @Override
    public ValidationResult<List<CampaignWithAllowedPageIds>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAllowedPageIds>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAllowedPageIdsValidator(sspPlatformsRepository))
                .getResult();
    }

    private static boolean isAllowedPageIdsChanged(ModelChanges<CampaignWithAllowedPageIds> mc) {
        return mc.isPropChanged(CampaignWithAllowedPageIds.ALLOWED_PAGE_IDS);
    }

}
