package ru.yandex.direct.core.entity.campaign.service.validation.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithAttributionModelValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAttributionModelUpdateValidationTypeSupport
        extends AbstractCampaignUpdateValidationTypeSupport<CampaignWithAttributionModel> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithAttributionModelUpdateValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithAttributionModel> getTypeClass() {
        return CampaignWithAttributionModel.class;
    }

    @Override
    public ValidationResult<List<CampaignWithAttributionModel>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithAttributionModel>, Defect> vr) {
        var clientId = container.getClientId();
        var featuresEnabledForClientId = featureService.getEnabledForClientId(clientId);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithAttributionModelValidator(featuresEnabledForClientId))
                .getResult();
    }

}
